clear all
clc
close all
% Define Cell Parameters
Q = 2*3600; %2Ah capacity
Ct = 2700; %Double layer capacitance
Rt = 0.011; %SEI layer Charge transfer resistance
Rs = 0.008; %Cell internal resistance
Rd = 1e6; %Self-discharge resistor
SOC_0=0.5; %Initial SOC
m=70e-3; %Battery mass
Cp=800; %Heat capacitance of the cell
h=10; %Still Air Convection Coefficient
% h=500;%Water convection coefficient
Rshort=0.5;% Short Circuit Resistance
T_inf=20;%Ambient Te,perature
A=50e-4; %Surface area of the cell

%OCV Look-Up Table
V=[2.25 3.2 3.25 3.25 3.3 3.3 3.3 3.35 3.35 3.35 3.75];
SOC=[0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];


[t,y]=sim('ShortCircuitModel');
figure
subplot(211)
plot(t,stateofcharge.signals.values,'Linew',1.5)
xlabel('Time (s)')
ylabel('SOC')
subplot(212)
plot(t,Temp.signals.values,'Linew',1.5)
xlabel('Time (s)')
ylabel('Temperature (C)')
box on
hold off